/* ================================================================
* THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
* WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL DINGOO GAMES OR ITS CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
* GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
* IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
* OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* ====================================================================
*/ 
#include "../inc/GameEngine.h"
int     A320_SCREEN_WIDTH = 320;
int     A320_SCREEN_HEIGHT = 240;

//--------------------------------------------------------------------------------------------------------
GameEngine::GameEngine( void* userdata [] ) : 
Engine( userdata )
{

}
//--------------------------------------------------------------------------------------------------------
GameEngine::~GameEngine( void )
{
 Free();
}
//--------------------------------------------------------------------------------------------------------
/// init all resources
result GameEngine::Init( void )
{
 InitDLRes();
 // 16 FPS
 SetFPS( 24 );

 return S2D_OK;
}
//--------------------------------------------------------------------------------------------------------
void GameEngine::Free( void )
{
 ReleaseDLRes();
}
//--------------------------------------------------------------------------------------------------------
void GameEngine::Exec( void )
{

}
//--------------------------------------------------------------------------------------------------------
void GameEngine::Exec2( void )
{

}
//--------------------------------------------------------------------------------------------------------
void GameEngine::PreRender( void )
{

}
//--------------------------------------------------------------------------------------------------------
void GameEngine::Render( void )
{
	//Pixel by pixel
	int r = 0;
	int g = 255;
	int b = 0;
	for(int i = 0; i < A320_SCREEN_HEIGHT;i++)
	{
		for (int j=0; j < A320_SCREEN_WIDTH; j++)
		{
			r+=1;
			PutPixel(i,j,r,g,b);
		}
		r += 1;
		g -= 1;
		b += 1;
	}
}
//--------------------------------------------------------------------------------------------------------
void GameEngine::PostRender( void )
{

}
//--------------------------------------------------------------------------------------------------------
void GameEngine::DispDebugInfo( void )
{

}

//--------------------------------------------------------------------------------------------------------
void  GameEngine::EnterGame( s32 MapId )
{ 

}
//--------------------------------------------------------------------------------------------------------
void  GameEngine::ExitGame( void )
{
 Exit();
}
//--------------------------------------------------------------------------------------------------------
void GameEngine::PutPixel(int x, int y, u8 r,u8 g, u8 b )
{
    Pixel* ptr = m_pDraw2D->GetVRAMPtr();
    Pixel color1(r,g,b);
    s32 ofs = (x*A320_SCREEN_WIDTH) + (y);

    ptr[ofs] = color1;
}